/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.apache.http.client.protocol;

import java.io.IOException;
import net.creeperhost.minetogether.org.apache.http.HttpEntity;
import net.creeperhost.minetogether.org.apache.http.HttpEntityEnclosingRequest;
import net.creeperhost.minetogether.org.apache.http.HttpException;
import net.creeperhost.minetogether.org.apache.http.HttpRequest;
import net.creeperhost.minetogether.org.apache.http.HttpRequestInterceptor;
import net.creeperhost.minetogether.org.apache.http.HttpVersion;
import net.creeperhost.minetogether.org.apache.http.ProtocolVersion;
import net.creeperhost.minetogether.org.apache.http.annotation.Contract;
import net.creeperhost.minetogether.org.apache.http.annotation.ThreadingBehavior;
import net.creeperhost.minetogether.org.apache.http.client.config.RequestConfig;
import net.creeperhost.minetogether.org.apache.http.client.protocol.HttpClientContext;
import net.creeperhost.minetogether.org.apache.http.protocol.HttpContext;
import net.creeperhost.minetogether.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

